import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/legacy.dart';
import 'package:shared_preferences/shared_preferences.dart';

class ThemeBloc extends ChangeNotifier{

  final String key = "theme";
  SharedPreferences? _pref;
  bool? _darkTheme;

  bool? get darkTheme => _darkTheme;

  ThemeBloc() {
    _darkTheme = false;
    _loadFromPrefs();
  }

  void toggleTheme(){
    _darkTheme = !_darkTheme!;
    _saveToPrefs();
    notifyListeners();
  }

  Future<void> _initPrefs() async {
    _pref ??= await SharedPreferences.getInstance();
  }

  Future<void> _loadFromPrefs() async {
      await _initPrefs();
      _darkTheme = _pref!.getBool(key) ?? false;
      notifyListeners();
  }
  
  Future<void> _saveToPrefs() async {
    await _initPrefs();
    _pref!.setBool(key, _darkTheme!);
  }

}

final themeBlocProvider = ChangeNotifierProvider<ThemeBloc>((ref) {
  return ThemeBloc();
});
